<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Certification extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = "certifications";
    protected $fillable = ['therapist_id','therapist_community_id', 'name', 'description', 'sort_order', 'image', 'is_active', 'deleted_at'];


    public function scopeWithAll($query)
    {
        return $query->with('therapist_community')->with('therapist');
    }
    public function scopeActive($query)
    {
        return $query->where('is_active', 1);
    }
    public function scopeFeatured($query)
    {
        return $query->where('is_featured', 1);
    }
    public function scopeHasModulePermissions($query){
        return $query->whereHas('therapist',function($q){
            $q->whereHas('pricing_plan',function($y){{
                $y->whereHas('therapist_modules',function($z){
                    $z->where('pricing_plan_modules.module_code','therapist-certifications');
                });
            }});
        })->orWhereHas('therapist_community',function($q){
            $q->whereHas('pricing_plan',function($y){{
                $y->whereHas('therapist_community_modules',function($z){
                    $z->where('pricing_plan_modules.module_code','therapist_community-certifications');
                });
            }});
        });
    }
    public function therapist()
    {
        return $this->belongsTo(Therapist::class);
    }
    public function therapist_community()
    {
        return $this->belongsTo(TherapistCommunity::class);
    }
}
